# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 3
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR3_strategy.txt
# LLM Suggested Fallback: D

def mutual_trust_builder(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate goodwill score to reward mutual cooperation
    goodwill_score = sum(1 for m, o in zip(my_history, opp_history) if m == "C" and o == "C")
    
    # Initial trust-building phase (Rounds 1-3)
    if len(opp_history) < 3:
        return "C"  # Always cooperate early to build trust
    
    # Conditional exploitation (Rounds 4-7)
    if 3 <= len(opp_history) < 7:
        # Check if opponent cooperated at least twice in first 3 rounds
        early_coop = sum(1 for move in opp_history[:3] if move == "C")
        if early_coop >= 2:
            return "D"  # Exploit their trust
        else:
            return "C"  # Continue cooperating to avoid suspicion
    
    # Late-game manipulation (Rounds 8-10)
    if len(opp_history) >= 7:
        # Check if opponent retaliated after our defection
        if len(my_history) > 0 and my_history[-1] == "D" and len(opp_history) > 0 and opp_history[-1] == "D":
            return "D"  # Tit-for-Tat to minimize losses
        else:
            return "D"  # Continue defecting if opponent remains cooperative
    
    # Default fallback move (should never reach here)
    return "D"